Libname q 'C:\SASCodeforBook\SASDataSets';

	/*Code for Table 9.1*/

data frauddata; set q.frauddata; 
run;

data first; set frauddata;

/* Table 9.1, Background Characteristics*/

Title 'Q37, Gender';
Proc mixed data=frauddata;
	class forclass;
	model mfem37 = forclass;
run;

Proc mixed data=frauddata;
	class threclas;
	model mfem37 = threclas;
run;

Title 'Q38, educational level';
Proc mixed data=frauddata;
	class forclass;
	model edlv38 = forclass;
run;

Proc mixed data=frauddata;
	class threclas;
	model edlv38 = threclas;
run;

Title 'Q36, Handles No Fault Claims';
Proc mixed data=frauddata;
	class forclass;
	model BIPIP36 = forclass;
run;

Proc mixed data=frauddata;
	class threclas;
	model BIPIP36 = threclas;
run;

Title 'Q33, Job Title';
Proc mixed data=frauddata;
	class forclass;
	model title33 = forclass;
run;

Proc mixed data=frauddata;
	class threclas;
	model title33 = threclas;
run;

Title 'Q34, Job Grade';
Proc mixed data=frauddata;
	class forclass;
	model grade34 = forclass;
run;

Proc mixed data=frauddata;
	class threclas;
	model grade34 = threclas;
run;

/* Table 9.1, Indicators of Office Morale*/

Title 'Q28, Trusts Coworkers';
Proc mixed data=frauddata;
	class forclass;
	model Trust28 = forclass;
run;

Proc mixed data=frauddata;
	class threclas;
	model Trust28 = threclas;
run;

Title 'Q22, Work Group is Terrific';
Proc mixed data=frauddata;
	class forclass;
	model Terif22 = forclass;
run;

Proc mixed data=frauddata;
	class threclas;
	model Terif22 = threclas;
run;

Title 'Q27, Supervisor is Very Effective';
Proc mixed data=frauddata;
	class forclass;
	model SupEf27 = forclass;
run;

Proc mixed data=frauddata;
	class threclas;
	model SupEf27 = threclas;
run;

Title 'Q20, SIU Handles Claims Very Well';
Proc mixed data=frauddata;
	class forclass;
	model BLDUP20 = forclass;
run;

Proc mixed data=frauddata;
	class threclas;
	model BLDUP20 = threclas;
run;

Title 'Q26, SIU is Helpful';
Proc mixed data=frauddata;
	class forclass;
	model SIUHF26 = forclass;
run;

Proc mixed data=frauddata;
	class threclas;
	model SIUHF26 = threclas;
run;

	/*Exposure to the Computerized Fraud Detector CFRD*/

Title 'Q40, Has Used CFRD';
Proc mixed data=frauddata;
	class forclass;
	model usesp40 = forclass;
run;

Proc mixed data=frauddata;
	class threclas;
	model usesp40 = threclas;
run;

Title 'Dislikes CFRD';
Proc mixed data=frauddata;
	class forclass;
	model Hatecfrd = forclass;
run;

Proc mixed data=frauddata;
	class threclas;
	model hatecfrd = threclas;
run;

		/*Bonferroni Corrected Probability Values*/

/*Table 9.1 Corrected probabilities using Bonferroni, Stepdown Bonferroni,Hoc=Hochberg,
	FDR=False Discovery Rate*/  

Title 'Bonferroni corrected probabilities for the four category design of Table 9.1';

data FourCategoryProbs; 
      input Test$ Raw_P; 
      datalines; 
Gender			.43
Education		.82
NoFaultClaims   .92
JobTitle 		.88
JobGrade		.68
TrustCoworkers	.97
WorkGroupFine	.48
SupervisorFine	.44
SIUFine		    .11
SIUHelpful		.27
UsedCFRD		.0001
DislikeCFRD	    .0001	
;
run;
proc multtest pdata=FourCategoryProbs Bon Holm Hoc FDR; 
run;

Title 'Bonferroni corrected probabilities for the three category design of Table 9.1';
data ThreeCategoryProbs; 
      input Test$ Raw_P; 
      datalines; 

Gender			.29
Education		.81
NoFaultClaims   .78
JobTitle 		.92
JobGrade		.90
TrustCoworkers	.99
WorkGroupFine	.85
SupervisorFine	.26
SIUFine		    .21
SIUHelpful		.94
UsedCFRD		.0001
DislikeCFRD	    .0001	
;
run;
proc multtest pdata=ThreeCategoryProbs Bon Holm Hoc FDR; 
run;

/*This ends the code for Table 9.1*/
/*The syntax in this file is copyright by Robert B. Smith,  2011*/


